clear;
clc;
fullScriptPath = matlab.desktop.editor.getActiveFilename();
[folderPath, ~, ~] = fileparts(fullScriptPath);
%% FILE1
%nomefile
%nomefile
file1 = 'C2_2025-07-22_15-52-37.txt';
file2 = 'C2_2025-05-05_12-25-47.txt';
% Define the names of the files you want to read
filename1 = fullfile(folderPath, file1);
filename2 = fullfile(folderPath, file2);
% Importa i dati
data_import_1 = importdata(filename1,'\t');
data_import_2 = importdata(filename2,'\t');
% Visualizza i dati
data1=data_import_1.data(5:end,:);
disp(data_import_1);
data2=data_import_2.data(5:end,:);
disp(data_import_2);

%% GRAFICI
%pitch
figure(1)

subplot(3,1,1)
plot(data1(:,1)-data1(1,1)-20,data1(:,16),"--k", 'LineWidth', 1.5)
hold on
plot(data1(:,1)-data1(1,1)-20,data1(:,15)+2.5,"k", 'LineWidth', 1.5)
hold on
plot(data2(:,1)-data2(1,1)-20,data2(:,15)+2.5,"--r", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('Velocity [feet/s]');
legend('com','response','nominal', 'Location', 'northeast');
xlim([0 100])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 800, 800]) % [x, y, width, height]
ylim([790 910])

subplot(3,1,2)
plot(data1(:,1)-data1(1,1)-20,data1(:,23),"k", 'LineWidth', 1.5)
hold on
plot(data2(:,1)-data2(1,1)-20,data2(:,23),"--r", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('throtte [%]');
xlim([0 100])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z

subplot(3,1,3)
plot(data1(:,1)-data1(1,1)-20,data1(:,29),"k", 'LineWidth', 1.5)
hold on
yline(0,"--r", 'LineWidth', 1.5)

grid on
xlabel('time [s]');
ylabel('wind [m/s]');
xlim([0 100])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z

